<?php include 'header.php'; include '../koneksi.php'; ?>

<div class="content-wrapper">
<section class="content-header">
  <h1>Hutang <small>Data Hutang</small></h1>
</section>

<section class="content">

<!-- FILTER -->
<div class="box box-info">
<div class="box-body">
<form method="get">
<div class="row">

<div class="col-md-4">
  <label>Dari Tanggal</label>
  <input type="date" name="tgl_dari" class="form-control"
    value="<?= $_GET['tgl_dari'] ?? '' ?>">
</div>

<div class="col-md-4">
  <label>Sampai Tanggal</label>
  <input type="date" name="tgl_sampai" class="form-control"
    value="<?= $_GET['tgl_sampai'] ?? '' ?>">
</div>

<div class="col-md-4">
  <label>&nbsp;</label><br>
  <button class="btn btn-info">Filter</button>
  <a href="hutang.php" class="btn btn-default">Reset</a>
</div>

</div>
</form>
</div>
</div>

<!-- DATA -->
<div class="box box-info">
<div class="box-header">
  <h3 class="box-title">Catatan Hutang</h3>

  <div class="pull-right">
    <a href="hutang_excel.php?tgl_dari=<?= $_GET['tgl_dari'] ?? '' ?>&tgl_sampai=<?= $_GET['tgl_sampai'] ?? '' ?>"
       class="btn btn-success btn-sm">
      <i class="fa fa-file-excel-o"></i> Export Excel
    </a>

    <button
      type="button"
      class="btn btn-info btn-sm"
      data-toggle="modal"
      data-target="#exampleModal">
      <i class="fa fa-plus"></i> Tambah Hutang
    </button>
  </div>
</div>

<div class="box-body table-responsive">
<table class="table table-bordered table-striped">
<thead>
<tr>
  <th>NO</th>
  <th>KODE</th>
  <th>TANGGAL</th>
  <th>KETERANGAN</th>
  <th>NOMINAL</th>
  <th>OPSI</th>
</tr>
</thead>
<tbody>

<?php
$where = "";
if(!empty($_GET['tgl_dari']) && !empty($_GET['tgl_sampai'])){
  $where = "WHERE hutang_tanggal BETWEEN '$_GET[tgl_dari]' AND '$_GET[tgl_sampai]'";
}

$no=1;
$data = mysqli_query($koneksi,"SELECT * FROM hutang $where ORDER BY hutang_tanggal DESC");
while($d=mysqli_fetch_array($data)){
?>
<tr>
  <td><?= $no++ ?></td>
  <td>HTG-<?= str_pad($d['hutang_id'],4,'0',STR_PAD_LEFT) ?></td>
  <td><?= date('d-m-Y',strtotime($d['hutang_tanggal'])) ?></td>
  <td><?= $d['hutang_keterangan'] ?></td>
  <td>Rp <?= number_format($d['hutang_nominal']) ?></td>
  <td>
    <button class="btn btn-warning btn-xs" data-toggle="modal" data-target="#edit<?= $d['hutang_id'] ?>">Edit</button>
    <a href="hutang_hapus.php?id=<?= $d['hutang_id'] ?>" class="btn btn-danger btn-xs" onclick="return confirm('Yakin hapus data?')">Hapus</a>
  </td>
</tr>

<!-- MODAL EDIT -->
<div class="modal fade" id="edit<?= $d['hutang_id'] ?>">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post" action="hutang_update.php">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Edit Hutang</h4>
        </div>

        <div class="modal-body">
          <input type="hidden" name="id" value="<?= $d['hutang_id'] ?>">

          <div class="form-group">
            <label>Tanggal</label>
            <input type="date" name="tanggal" value="<?= $d['hutang_tanggal'] ?>" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Keterangan</label>
            <input type="text" name="keterangan" value="<?= $d['hutang_keterangan'] ?>" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Nominal</label>
            <input type="number" name="nominal" value="<?= $d['hutang_nominal'] ?>" class="form-control" required>
          </div>
        </div>

        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
          <button class="btn btn-warning">Update</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php } ?>

</tbody>
</table>
</div>
</div>

</section>
</div>

<!-- MODAL TAMBAH -->
<div class="modal fade" id="exampleModal">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post" action="hutang_act.php">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Tambah Hutang</h4>
        </div>

        <div class="modal-body">
          <div class="form-group">
            <label>Tanggal</label>
            <input type="date" name="tanggal" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Keterangan</label>
            <input type="text" name="keterangan" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Nominal</label>
            <input type="number" name="nominal" class="form-control" required>
          </div>
        </div>

        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
          <button class="btn btn-info">Simpan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include 'footer.php'; ?>
