<?php
include '../koneksi.php';
include 'header.php';
?>

<div class="content-wrapper">
  <section class="content-header">
    <h1>
      Project
      <small>Data Project</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="index.php"><i class="fa fa-dashboard"></i> Dashboard</a></li>
      <li class="active">Project</li>
    </ol>
  </section>

  <section class="content">

    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">Data Project</h3>

        <!-- TOMBOL POJOK KANAN -->
        <div class="box-tools pull-right">
          <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modalProject">
            <i class="fa fa-plus"></i> Tambah Project
          </button>
        </div>
      </div>

      <!-- TABLE (kosong dulu / bisa dikembangkan) -->
      <div class="box-body">
        <table class="table table-bordered table-striped">
          <thead>
            <tr>
              <th width="5%">No</th>
              <th>Nama Project</th>
              <th>Klien</th>
              <th>Nilai</th>
              <th>Status</th>
              <th width="10%">Opsi</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $no = 1;
            $data = mysqli_query($koneksi, "SELECT * FROM project ORDER BY id DESC");
            while ($d = mysqli_fetch_array($data)) {
            ?>
            <tr>
              <td><?= $no++; ?></td>
              <td><?= $d['nama_project']; ?></td>
              <td><?= $d['klien']; ?></td>
              <td><?= number_format($d['nilai_project']); ?></td>
              <td>
                <span class="label label-info"><?= $d['status']; ?></span>
              </td>
              <td>
                <button class="btn btn-xs btn-danger">
                  <i class="fa fa-trash"></i>
                </button>
              </td>
            </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>

  </section>
</div>

<!-- MODAL INPUT PROJECT -->
<div class="modal fade" id="modalProject">
  <div class="modal-dialog">
    <div class="modal-content">

      <form method="post" action="simpan_project.php">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Tambah Project</h4>
        </div>

        <div class="modal-body">

          <div class="form-group">
            <label>Nama Project</label>
            <input type="text" name="nama_project" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Nama Klien</label>
            <input type="text" name="klien" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Nilai Project</label>
            <input type="number" name="nilai_project" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Tanggal Mulai</label>
            <input type="date" name="tanggal_mulai" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Tanggal Selesai</label>
            <input type="date" name="tanggal_selesai" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Status</label>
            <select name="status" class="form-control" required>
              <option value="">-- Pilih Status --</option>
              <option value="Perencanaan">Perencanaan</option>
              <option value="Berjalan">Berjalan</option>
              <option value="Selesai">Selesai</option>
            </select>
          </div>

        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fa fa-save"></i> Simpan
          </button>
          <button type="button" class="btn btn-default" data-dismiss="modal">
            Batal
          </button>
        </div>
      </form>

    </div>
  </div>
</div>

<?php include 'footer.php'; ?>
