<?php
include '../koneksi.php';
include 'header.php';
?>

<div class="content-wrapper">
<section class="content-header">
  <h1>Laporan <small>Data Laporan</small></h1>
</section>

<section class="content">

<div class="box box-info">
<div class="box-header with-border">
  <h3 class="box-title">Filter Laporan</h3>
</div>

<div class="box-body">
<form method="get" action="">
<div class="row">

<div class="col-md-3">
<label>Mulai Tanggal</label>
<input type="date" name="tanggal_dari" class="form-control"
 value="<?= $_GET['tanggal_dari'] ?? '' ?>" required>
</div>

<div class="col-md-3">
<label>Sampai Tanggal</label>
<input type="date" name="tanggal_sampai" class="form-control"
 value="<?= $_GET['tanggal_sampai'] ?? '' ?>" required>
</div>

<div class="col-md-3">
<label>Kategori</label>
<select name="kategori" class="form-control">
<option value="semua">- Semua Kategori -</option>
<?php
$kategori=mysqli_query($koneksi,"SELECT * FROM kategori");
while($k=mysqli_fetch_array($kategori)){
?>
<option value="<?= $k['kategori_id'] ?>"
 <?= (($_GET['kategori'] ?? '')==$k['kategori_id'])?'selected':'' ?>>
 <?= $k['kategori'] ?>
</option>
<?php } ?>
</select>
</div>

<div class="col-md-3">
<br>
<button type="submit" class="btn btn-info btn-block">Tampilkan</button>
</div>

</div>
</form>
</div>
</div>

<?php if(isset($_GET['tanggal_dari'])){ ?>

<div class="box box-info">
<div class="box-header with-border">
  <h3 class="box-title">Laporan Pemasukan & Pengeluaran</h3>

  <!-- ===== TOMBOL EXPORT & PRINT ===== -->
  <div class="pull-right">
    <a href="laporan_excel.php?tanggal_dari=<?= $_GET['tanggal_dari'] ?>&tanggal_sampai=<?= $_GET['tanggal_sampai'] ?>&kategori=<?= $_GET['kategori'] ?>"
       class="btn btn-success btn-sm">
       <i class="fa fa-file-excel-o"></i> EXPORT EXCEL
    </a>

    <a href="laporan_print.php?tanggal_dari=<?= $_GET['tanggal_dari'] ?>&tanggal_sampai=<?= $_GET['tanggal_sampai'] ?>&kategori=<?= $_GET['kategori'] ?>"
       target="_blank"
       class="btn btn-primary btn-sm">
       <i class="fa fa-print"></i> PRINT
    </a>
  </div>
</div>

<div class="box-body table-responsive">
<table class="table table-bordered table-striped">
<thead>
<tr>
<th>No</th>
<th>Tanggal</th>
<th>Kategori</th>
<th>Keterangan</th>
<th>Pemasukan</th>
<th>Pengeluaran</th>
</tr>
</thead>
<tbody>

<?php
$no=1;
$total_pemasukan=0;
$total_pengeluaran=0;

$where_kategori="";
if($_GET['kategori']!="semua"){
  $where_kategori="AND transaksi_kategori='".$_GET['kategori']."'";
}

$data=mysqli_query($koneksi,"
SELECT 
  t.*,
  k.kategori,
  p.nama_project
FROM transaksi t
LEFT JOIN kategori k ON k.kategori_id=t.transaksi_kategori
LEFT JOIN project p ON p.id=t.transaksi_project
WHERE transaksi_tanggal BETWEEN '".$_GET['tanggal_dari']."' AND '".$_GET['tanggal_sampai']."'
$where_kategori
ORDER BY transaksi_tanggal ASC
");

while($d=mysqli_fetch_array($data)){
?>

<tr>
<td><?= $no++ ?></td>
<td><?= date('d-m-Y',strtotime($d['transaksi_tanggal'])) ?></td>
<td><?= $d['kategori'] ?></td>

<!-- ===== KETERANGAN + PROJECT ===== -->
<td>
<?= $d['transaksi_keterangan'] ?>
<?php if($d['nama_project']!=""){ ?>
<br>
<small class="text-muted">(Project: <?= $d['nama_project'] ?>)</small>
<?php } ?>
</td>

<td class="text-center">
<?php
if($d['transaksi_jenis']=="Pemasukan"){
  echo "Rp ".number_format($d['transaksi_nominal']);
  $total_pemasukan += $d['transaksi_nominal'];
}else{
  echo "-";
}
?>
</td>

<td class="text-center">
<?php
if($d['transaksi_jenis']=="Pengeluaran"){
  echo "Rp ".number_format($d['transaksi_nominal']);
  $total_pengeluaran += $d['transaksi_nominal'];
}else{
  echo "-";
}
?>
</td>
</tr>

<?php } ?>

<tr>
<th colspan="4" class="text-right">TOTAL</th>
<th class="text-center text-success">Rp <?= number_format($total_pemasukan) ?></th>
<th class="text-center text-danger">Rp <?= number_format($total_pengeluaran) ?></th>
</tr>

<tr>
<th colspan="5" class="text-right">SALDO</th>
<th class="text-center">
Rp <?= number_format($total_pemasukan - $total_pengeluaran) ?>
</th>
</tr>

</tbody>
</table>
</div>
</div>

<?php } ?>

</section>
</div>

<?php include 'footer.php'; ?>
