<?php
include '../koneksi.php';
require_once '../assets/mpdf/autoload.php';

$mpdf = new \Mpdf\Mpdf();

$tanggal_dari   = $_GET['tanggal_dari'];
$tanggal_sampai = $_GET['tanggal_sampai'];
$kategori       = $_GET['kategori'];

$html = '
<h3 align="center">LAPORAN SISTEM INFORMASI KEUANGAN</h3>
<p>
Dari Tanggal : '.date('d/m/Y',strtotime($tanggal_dari)).'<br>
Sampai Tanggal : '.date('d/m/Y',strtotime($tanggal_sampai)).'<br>
Kategori : '.($kategori=="semua"?"SEMUA KATEGORI":$kategori).'
</p>

<table border="1" width="100%" cellpadding="6" cellspacing="0">
<tr>
<th>NO</th>
<th>TANGGAL</th>
<th>KATEGORI</th>
<th>KETERANGAN</th>
<th>PEMASUKAN</th>
<th>PENGELUARAN</th>
</tr>';

$no=1;
$total_masuk=0;
$total_keluar=0;

$where_kategori="";
if($kategori!="semua"){
  $where_kategori="AND transaksi_kategori='$kategori'";
}

$data=mysqli_query($koneksi,"
SELECT 
  t.*,
  k.kategori,
  p.nama_project
FROM transaksi t
LEFT JOIN kategori k ON k.kategori_id=t.transaksi_kategori
LEFT JOIN project p ON p.id=t.transaksi_project
WHERE transaksi_tanggal BETWEEN '$tanggal_dari' AND '$tanggal_sampai'
$where_kategori
ORDER BY transaksi_tanggal ASC
");

while($d=mysqli_fetch_array($data)){
  $html .= '<tr>
  <td>'.$no++.'</td>
  <td>'.date('d/m/Y',strtotime($d['transaksi_tanggal'])).'</td>
  <td>'.$d['kategori'].'</td>
  <td>'.$d['transaksi_keterangan'];

  if($d['nama_project']!=""){
    $html .= '<br><small>(Project: '.$d['nama_project'].')</small>';
  }

  $html .= '</td>
  <td>'.($d['transaksi_jenis']=="Pemasukan"?number_format($d['transaksi_nominal']):'-').'</td>
  <td>'.($d['transaksi_jenis']=="Pengeluaran"?number_format($d['transaksi_nominal']):'-').'</td>
  </tr>';

  if($d['transaksi_jenis']=="Pemasukan"){
    $total_masuk += $d['transaksi_nominal'];
  }else{
    $total_keluar += $d['transaksi_nominal'];
  }
}

$html .= '
<tr>
<th colspan="4">TOTAL</th>
<th>'.number_format($total_masuk).'</th>
<th>'.number_format($total_keluar).'</th>
</tr>
<tr>
<th colspan="5">SALDO</th>
<th>'.number_format($total_masuk - $total_keluar).'</th>
</tr>
</table>';

$mpdf->WriteHTML($html);
$mpdf->Output("Laporan_Keuangan.pdf","I");
