<?php
include '../koneksi.php';
include 'header.php';
?>

<div class="content-wrapper">
<section class="content-header">
  <h1>Project <small>Data Project</small></h1>
</section>

<section class="content">

<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title">Data Project</h3>
    <div class="box-tools pull-right">
      <a href="export_project.php" class="btn btn-success btn-sm">
        <i class="fa fa-file-excel-o"></i> Export Excel
      </a>
      <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modalTambah">
        <i class="fa fa-plus"></i> Tambah Project
      </button>
    </div>
  </div>

  <div class="box-body">
    <table class="table table-bordered table-striped">
      <thead>
        <tr>
          <th>No</th>
          <th>Nama Project</th>
          <th>Klien</th>
          <th>Nilai</th>
          <th>Status</th>
          <th width="15%">Opsi</th>
        </tr>
      </thead>
      <tbody>

<?php
$no=1;
$q=mysqli_query($koneksi,"SELECT * FROM project ORDER BY id DESC");
while($d=mysqli_fetch_array($q)){
?>

<tr>
  <td><?= $no++ ?></td>
  <td><?= $d['nama_project'] ?></td>
  <td><?= $d['klien'] ?></td>
  <td><?= number_format($d['nilai_project']) ?></td>
  <td>
    <span class="label label-info"><?= $d['status'] ?></span>
  </td>
  <td>
    <!-- EDIT -->
    <button class="btn btn-warning btn-xs" data-toggle="modal" data-target="#edit<?= $d['id'] ?>">
      <i class="fa fa-edit"></i>
    </button>

    <!-- HAPUS -->
    <a href="hapus_project.php?id=<?= $d['id'] ?>"
       onclick="return confirm('Yakin hapus data ini?')"
       class="btn btn-danger btn-xs">
      <i class="fa fa-trash"></i>
    </a>
  </td>
</tr>

<!-- MODAL EDIT -->
<div class="modal fade" id="edit<?= $d['id'] ?>">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post" action="edit_project.php">
        <input type="hidden" name="id" value="<?= $d['id'] ?>">

        <div class="modal-header">
          <h4 class="modal-title">Edit Project</h4>
        </div>

        <div class="modal-body">
          <input type="text" name="nama_project" class="form-control" value="<?= $d['nama_project'] ?>" required><br>
          <input type="text" name="klien" class="form-control" value="<?= $d['klien'] ?>" required><br>
          <input type="number" name="nilai_project" class="form-control" value="<?= $d['nilai_project'] ?>" required><br>
          <select name="status" class="form-control" required>
            <option <?= $d['status']=='Perencanaan'?'selected':'' ?>>Perencanaan</option>
            <option <?= $d['status']=='Berjalan'?'selected':'' ?>>Berjalan</option>
            <option <?= $d['status']=='Selesai'?'selected':'' ?>>Selesai</option>
          </select>
        </div>

        <div class="modal-footer">
          <button class="btn btn-primary">Update</button>
          <button class="btn btn-default" data-dismiss="modal">Batal</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php } ?>

      </tbody>
    </table>
  </div>
</div>

</section>
</div>

<!-- MODAL TAMBAH -->
<div class="modal fade" id="modalTambah">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post" action="simpan_project.php">
        <div class="modal-header">
          <h4 class="modal-title">Tambah Project</h4>
        </div>

        <div class="modal-body">
          <input type="text" name="nama_project" class="form-control" placeholder="Nama Project" required><br>
          <input type="text" name="klien" class="form-control" placeholder="Nama Klien" required><br>
          <input type="number" name="nilai_project" class="form-control" placeholder="Nilai Project" required><br>
          <input type="date" name="tanggal_mulai" class="form-control" required><br>
          <input type="date" name="tanggal_selesai" class="form-control" required><br>
          <select name="status" class="form-control" required>
            <option value="">Pilih Status</option>
            <option>Perencanaan</option>
            <option>Berjalan</option>
            <option>Selesai</option>
          </select>
        </div>

        <div class="modal-footer">
          <button class="btn btn-primary">Simpan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include 'footer.php'; ?>
