<?php
include '../koneksi.php';
include 'header.php';

/* ================= AMBIL DATA TRANSAKSI ================= */
$transaksi = [];
$data = mysqli_query($koneksi,"
  SELECT 
    t.*,
    k.kategori,
    p.nama_project,
    b.bank_nama
  FROM transaksi t
  LEFT JOIN kategori k ON k.kategori_id=t.transaksi_kategori
  LEFT JOIN project p ON p.id=t.transaksi_project
  LEFT JOIN bank b ON b.bank_id=t.transaksi_bank
  ORDER BY t.transaksi_id DESC
");

while($d = mysqli_fetch_assoc($data)){
  $transaksi[] = $d;
}
?>

<div class="content-wrapper">
<section class="content-header">
  <h1>Transaksi <small>Data Transaksi</small></h1>
</section>

<section class="content">
<div class="box box-info">

<div class="box-header with-border">
  <h3 class="box-title">Transaksi Pemasukan & Pengeluaran</h3>
  <div class="pull-right">
    <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#modalTambah">
      <i class="fa fa-plus"></i> Tambah Transaksi
    </button>
  </div>
</div>

<div class="box-body table-responsive">
<table class="table table-bordered table-striped" id="table-datatable">
<thead>
<tr>
  <th>No</th>
  <th>Tanggal</th>
  <th>Kategori</th>
  <th>Project</th>
  <th>Keterangan</th>
  <th>Pemasukan</th>
  <th>Pengeluaran</th>
  <th>Opsi</th>
</tr>
</thead>
<tbody>

<?php $no=1; foreach($transaksi as $d){ ?>
<tr>
<td><?= $no++ ?></td>
<td><?= date('d-m-Y',strtotime($d['transaksi_tanggal'])) ?></td>
<td><?= $d['kategori'] ?></td>
<td><?= $d['nama_project'] ?? '-' ?></td>
<td><?= $d['transaksi_keterangan'] ?></td>

<td class="text-center">
<?= $d['transaksi_jenis']=="Pemasukan" ? "Rp. ".number_format($d['transaksi_nominal']).",-" : "-" ?>
</td>

<td class="text-center">
<?= $d['transaksi_jenis']=="Pengeluaran" ? "Rp. ".number_format($d['transaksi_nominal']).",-" : "-" ?>
</td>

<td>
<button class="btn btn-warning btn-xs" data-toggle="modal" data-target="#edit<?= $d['transaksi_id'] ?>">
 <i class="fa fa-cog"></i>
</button>
<button class="btn btn-danger btn-xs" data-toggle="modal" data-target="#hapus<?= $d['transaksi_id'] ?>">
 <i class="fa fa-trash"></i>
</button>
<button class="btn btn-primary btn-xs" data-toggle="modal" data-target="#lihat<?= $d['transaksi_id'] ?>">
 <i class="fa fa-eye"></i>
</button>
</td>
</tr>
<?php } ?>

</tbody>
</table>
</div>
</div>
</section>
</div>

<!-- ===================================================== -->
<!-- =================== MODAL AREA ====================== -->
<!-- ===================================================== -->

<!-- ================= MODAL TAMBAH ================= -->
<form action="transaksi_act.php" method="post" enctype="multipart/form-data">
<div class="modal fade" id="modalTambah">
<div class="modal-dialog">
<div class="modal-content">

<div class="modal-header">
<h4 class="modal-title">Tambah Transaksi</h4>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>

<div class="modal-body">

<div class="form-group">
<label>Tanggal</label>
<input type="date" name="tanggal" class="form-control" required>
</div>

<div class="form-group">
<label>Jenis</label>
<select name="jenis" class="form-control" required>
<option value="">- Pilih -</option>
<option value="Pemasukan">Pemasukan</option>
<option value="Pengeluaran">Pengeluaran</option>
</select>
</div>

<div class="form-group">
<label>Kategori</label>
<select name="kategori" class="form-control" required>
<option value="">- Pilih -</option>
<?php
$kat = mysqli_query($koneksi,"SELECT * FROM kategori");
while($k=mysqli_fetch_assoc($kat)){
?>
<option value="<?= $k['kategori_id'] ?>"><?= $k['kategori'] ?></option>
<?php } ?>
</select>
</div>

<div class="form-group">
<label>Project</label>
<select name="project" class="form-control">
<option value="">- Tanpa Project -</option>
<?php
$pr = mysqli_query($koneksi,"SELECT * FROM project");
while($p=mysqli_fetch_assoc($pr)){
?>
<option value="<?= $p['id'] ?>"><?= $p['nama_project'] ?></option>
<?php } ?>
</select>
</div>

<div class="form-group">
<label>Nominal</label>
<input type="number" name="nominal" class="form-control" required>
</div>

<div class="form-group">
<label>Keterangan</label>
<textarea name="keterangan" class="form-control"></textarea>
</div>

<div class="form-group">
<label>Upload Bukti</label>
<input type="file" name="trnfoto" class="form-control">
</div>

<div class="form-group">
<label>Rekening Bank</label>
<select name="bank" class="form-control" required>
<option value="">- Pilih -</option>
<?php
$bk = mysqli_query($koneksi,"SELECT * FROM bank");
while($b=mysqli_fetch_assoc($bk)){
?>
<option value="<?= $b['bank_id'] ?>"><?= $b['bank_nama'] ?></option>
<?php } ?>
</select>
</div>

</div>

<div class="modal-footer">
<button type="button" class="btn btn-default" data-dismiss="modal">Tutup</button>
<button type="submit" class="btn btn-primary">Simpan</button>
</div>

</div>
</div>
</div>
</form>

<!-- ================= MODAL EDIT / HAPUS / LIHAT ================= -->
<?php foreach($transaksi as $d){ ?>

<form action="transaksi_update.php" method="post" enctype="multipart/form-data">
<div class="modal fade" id="edit<?= $d['transaksi_id'] ?>">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h4>Edit Transaksi</h4>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body">
<input type="hidden" name="id" value="<?= $d['transaksi_id'] ?>">

<div class="form-group">
<label>Tanggal</label>
<input type="date" name="tanggal" class="form-control" value="<?= $d['transaksi_tanggal'] ?>" required>
</div>

<div class="form-group">
<label>Jenis</label>
<select name="jenis" class="form-control" required>
<option value="Pemasukan" <?= $d['transaksi_jenis']=="Pemasukan"?'selected':'' ?>>Pemasukan</option>
<option value="Pengeluaran" <?= $d['transaksi_jenis']=="Pengeluaran"?'selected':'' ?>>Pengeluaran</option>
</select>
</div>

<div class="form-group">
<label>Kategori</label>
<select name="kategori" class="form-control" required>
<?php
$kat = mysqli_query($koneksi,"SELECT * FROM kategori");
while($k=mysqli_fetch_assoc($kat)){
?>
<option value="<?= $k['kategori_id'] ?>" <?= $d['transaksi_kategori']==$k['kategori_id']?'selected':'' ?>>
<?= $k['kategori'] ?>
</option>
<?php } ?>
</select>
</div>

<div class="form-group">
<label>Project</label>
<select name="project" class="form-control">
<option value="">- Tanpa Project -</option>
<?php
$pr = mysqli_query($koneksi,"SELECT * FROM project");
while($p=mysqli_fetch_assoc($pr)){
?>
<option value="<?= $p['id'] ?>" <?= $d['transaksi_project']==$p['id']?'selected':'' ?>>
<?= $p['nama_project'] ?>
</option>
<?php } ?>
</select>
</div>

<div class="form-group">
<label>Nominal</label>
<input type="number" name="nominal" class="form-control" value="<?= $d['transaksi_nominal'] ?>" required>
</div>

<div class="form-group">
<label>Keterangan</label>
<textarea name="keterangan" class="form-control"><?= $d['transaksi_keterangan'] ?></textarea>
</div>

<div class="form-group">
<label>Upload Bukti</label>
<input type="file" name="trnfoto" class="form-control">
</div>

<div class="form-group">
<label>Rekening Bank</label>
<select name="bank" class="form-control" required>
<?php
$bk = mysqli_query($koneksi,"SELECT * FROM bank");
while($b=mysqli_fetch_assoc($bk)){
?>
<option value="<?= $b['bank_id'] ?>" <?= $d['transaksi_bank']==$b['bank_id']?'selected':'' ?>>
<?= $b['bank_nama'] ?>
</option>
<?php } ?>
</select>
</div>

</div>
<div class="modal-footer">
<button type="button" class="btn btn-default" data-dismiss="modal">Tutup</button>
<button type="submit" class="btn btn-primary">Update</button>
</div>
</div>
</div>
</div>
</form>

<div class="modal fade" id="lihat<?= $d['transaksi_id'] ?>">
<div class="modal-dialog modal-lg">
<div class="modal-content">
<div class="modal-header">
<h4>Bukti Transaksi</h4>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body">
<?php if($d['transaksi_foto']!=""){ ?>
<embed src="../gambar/bukti/<?= $d['transaksi_foto'] ?>" width="100%" height="400">
<?php }else{ ?>
<p class="text-center text-muted">Tidak ada file</p>
<?php } ?>
</div>
</div>
</div>
</div>

<div class="modal fade" id="hapus<?= $d['transaksi_id'] ?>">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header"><h4>Peringatan!</h4></div>
<div class="modal-body">Yakin ingin menghapus data ini?</div>
<div class="modal-footer">
<button class="btn btn-default" data-dismiss="modal">Batal</button>
<a href="transaksi_hapus.php?id=<?= $d['transaksi_id'] ?>" class="btn btn-danger">Hapus</a>
</div>
</div>
</div>
</div>

<?php } ?>

<?php include 'footer.php'; ?>
