<?php
include 'header.php';
include '../koneksi.php';

$tgl_dari   = isset($_GET['tgl_dari']) ? $_GET['tgl_dari'] : '';
$tgl_sampai = isset($_GET['tgl_sampai']) ? $_GET['tgl_sampai'] : '';
?>

<div class="content-wrapper">

<section class="content-header">
  <h1>Hutang <small>Data Hutang</small></h1>
</section>

<section class="content">

<!-- FILTER (OPTIONAL) -->
<div class="box box-info">
<div class="box-body">
<form method="get">
<div class="row">

<div class="col-md-4">
  <label>Dari Tanggal</label>
  <input type="date" name="tgl_dari" class="form-control" value="<?= $tgl_dari ?>">
</div>

<div class="col-md-4">
  <label>Sampai Tanggal</label>
  <input type="date" name="tgl_sampai" class="form-control" value="<?= $tgl_sampai ?>">
</div>

<div class="col-md-4">
  <label>&nbsp;</label><br>
  <button type="submit" class="btn btn-info">Filter</button>
  <a href="hutang.php" class="btn btn-default">Reset</a>
</div>

</div>
</form>
</div>
</div>

<!-- DATA -->
<div class="box box-info">
<div class="box-header">
  <h3 class="box-title">Daftar Hutang</h3>

  <div class="pull-right">
    <a href="hutang_excel.php?tgl_dari=<?= $tgl_dari ?>&tgl_sampai=<?= $tgl_sampai ?>" class="btn btn-success btn-sm">
      <i class="fa fa-file-excel-o"></i> Export Excel
    </a>
  </div>
</div>

<div class="box-body table-responsive">
<table class="table table-bordered table-striped" id="table-datatable">
<thead>
<tr>
  <th width="5%">NO</th>
  <th width="15%">KODE</th>
  <th width="20%">TANGGAL</th>
  <th>KETERANGAN</th>
  <th width="20%">NOMINAL</th>
</tr>
</thead>
<tbody>

<?php
$where = "";
if($tgl_dari && $tgl_sampai){
  $where = "WHERE hutang_tanggal BETWEEN '$tgl_dari' AND '$tgl_sampai'";
}

$no = 1;
$data = mysqli_query($koneksi,"
  SELECT * FROM hutang
  $where
  ORDER BY hutang_tanggal DESC
");

while($d = mysqli_fetch_array($data)){
?>
<tr>
  <td><?= $no++ ?></td>
  <td>HTG-<?= str_pad($d['hutang_id'], 4, '0', STR_PAD_LEFT) ?></td>
  <td><?= date('d-m-Y', strtotime($d['hutang_tanggal'])) ?></td>
  <td><?= $d['hutang_keterangan'] ?></td>
  <td class="text-right">Rp. <?= number_format($d['hutang_nominal']) ?> ,-</td>
</tr>
<?php } ?>

</tbody>
</table>
</div>
</div>

</section>
</div>

<?php include 'footer.php'; ?>
