<?php
include '../koneksi.php';
require_once '../assets/mpdf/autoload.php';

$tanggal_dari   = $_GET['tanggal_dari'];
$tanggal_sampai = $_GET['tanggal_sampai'];
$kategori       = $_GET['kategori'];

$mpdf = new \Mpdf\Mpdf([
    'margin_left'   => 10,
    'margin_right'  => 10,
    'margin_top'    => 10,
    'margin_bottom' => 10
]);

$html = '
<h3 style="text-align:center;">LAPORAN SISTEM INFORMASI KEUANGAN</h3>

<p>
Dari Tanggal : '.date('d/m/Y',strtotime($tanggal_dari)).'<br>
Sampai Tanggal : '.date('d/m/Y',strtotime($tanggal_sampai)).'<br>
Kategori : '.($kategori=="semua" ? "SEMUA KATEGORI" : $kategori).'
</p>

<table width="100%" border="1" cellpadding="6" cellspacing="0" style="border-collapse:collapse;">
<tr style="background:#f0f0f0;">
<th width="5%">NO</th>
<th width="15%">TANGGAL</th>
<th width="20%">KATEGORI</th>
<th width="30%">KETERANGAN</th>
<th width="15%">PEMASUKAN</th>
<th width="15%">PENGELUARAN</th>
</tr>';

$no = 1;
$total_masuk  = 0;
$total_keluar = 0;

$where_kategori = "";
if($kategori != "semua"){
    $where_kategori = "AND transaksi_kategori='$kategori'";
}

$data = mysqli_query($koneksi,"
SELECT 
    t.*,
    k.kategori,
    p.nama_project
FROM transaksi t
LEFT JOIN kategori k ON k.kategori_id=t.transaksi_kategori
LEFT JOIN project p ON p.id=t.transaksi_project
WHERE transaksi_tanggal BETWEEN '$tanggal_dari' AND '$tanggal_sampai'
$where_kategori
ORDER BY transaksi_tanggal ASC
");

while($d = mysqli_fetch_array($data)){
    $html .= '<tr>
    <td align="center">'.$no++.'</td>
    <td>'.date('d/m/Y',strtotime($d['transaksi_tanggal'])).'</td>
    <td>'.$d['kategori'].'</td>
    <td>'.$d['transaksi_keterangan'];

    if($d['nama_project'] != ""){
        $html .= '<br><small>(Project: '.$d['nama_project'].')</small>';
    }

    $html .= '</td>
    <td align="right">'.($d['transaksi_jenis']=="Pemasukan" ? number_format($d['transaksi_nominal']) : '-').'</td>
    <td align="right">'.($d['transaksi_jenis']=="Pengeluaran" ? number_format($d['transaksi_nominal']) : '-').'</td>
    </tr>';

    if($d['transaksi_jenis']=="Pemasukan"){
        $total_masuk += $d['transaksi_nominal'];
    }else{
        $total_keluar += $d['transaksi_nominal'];
    }
}

$html .= '
<tr>
<th colspan="4" align="right">TOTAL</th>
<th align="right">'.number_format($total_masuk).'</th>
<th align="right">'.number_format($total_keluar).'</th>
</tr>

<tr>
<th colspan="5" align="right">SALDO</th>
<th align="right">'.number_format($total_masuk - $total_keluar).'</th>
</tr>
</table>';

$mpdf->WriteHTML($html);
$mpdf->Output("Laporan_Keuangan.pdf", "I");
