<?php
include '../koneksi.php';

$tanggal_dari   = $_GET['tanggal_dari'];
$tanggal_sampai = $_GET['tanggal_sampai'];
$kategori       = $_GET['kategori'];
?>

<!DOCTYPE html>
<html>
<head>
<title>Laporan Keuangan</title>
<style>
body{
  font-family: Arial, Helvetica, sans-serif;
}
table{
  border-collapse: collapse;
  width: 100%;
}
table, th, td{
  border: 1px solid black;
}
th, td{
  padding: 6px;
  font-size: 12px;
}
th{
  background: #f0f0f0;
}
</style>
</head>

<body onload="window.print()">

<h3 align="center">LAPORAN SISTEM INFORMASI KEUANGAN</h3>

<p>
Dari Tanggal : <?= date('d/m/Y',strtotime($tanggal_dari)) ?><br>
Sampai Tanggal : <?= date('d/m/Y',strtotime($tanggal_sampai)) ?><br>
Kategori : <?= $kategori=="semua" ? "SEMUA KATEGORI" : $kategori ?>
</p>

<table>
<tr>
  <th>NO</th>
  <th>TANGGAL</th>
  <th>KATEGORI</th>
  <th>KETERANGAN</th>
  <th>PEMASUKAN</th>
  <th>PENGELUARAN</th>
</tr>

<?php
$no=1;
$total_masuk=0;
$total_keluar=0;

$where_kategori="";
if($kategori!="semua"){
  $where_kategori="AND transaksi_kategori='$kategori'";
}

$data=mysqli_query($koneksi,"
SELECT 
  t.*,
  k.kategori,
  p.nama_project
FROM transaksi t
LEFT JOIN kategori k ON k.kategori_id=t.transaksi_kategori
LEFT JOIN project p ON p.id=t.transaksi_project
WHERE transaksi_tanggal BETWEEN '$tanggal_dari' AND '$tanggal_sampai'
$where_kategori
ORDER BY transaksi_tanggal ASC
");

while($d=mysqli_fetch_array($data)){
?>
<tr>
<td><?= $no++ ?></td>
<td><?= date('d/m/Y',strtotime($d['transaksi_tanggal'])) ?></td>
<td><?= $d['kategori'] ?></td>

<td>
<?= $d['transaksi_keterangan'] ?>
<?php if($d['nama_project']!=""){ ?>
<br><small>(Project: <?= $d['nama_project'] ?>)</small>
<?php } ?>
</td>

<td align="right">
<?php
if($d['transaksi_jenis']=="Pemasukan"){
  echo number_format($d['transaksi_nominal']);
  $total_masuk += $d['transaksi_nominal'];
}else{
  echo "-";
}
?>
</td>

<td align="right">
<?php
if($d['transaksi_jenis']=="Pengeluaran"){
  echo number_format($d['transaksi_nominal']);
  $total_keluar += $d['transaksi_nominal'];
}else{
  echo "-";
}
?>
</td>
</tr>
<?php } ?>

<tr>
<th colspan="4" align="right">TOTAL</th>
<th align="right"><?= number_format($total_masuk) ?></th>
<th align="right"><?= number_format($total_keluar) ?></th>
</tr>

<tr>
<th colspan="5" align="right">SALDO</th>
<th align="right"><?= number_format($total_masuk - $total_keluar) ?></th>
</tr>

</table>

</body>
</html>
