<?php include 'header.php'; ?>

<div class="content-wrapper">
<section class="content-header">
  <h1>Transaksi <small>Data Transaksi</small></h1>
</section>

<section class="content">
<div class="box box-info">

<div class="box-header">
  <h3 class="box-title">Transaksi Pemasukan & Pengeluaran</h3>
  <div class="pull-right">
    <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#modalTambah">
      <i class="fa fa-plus"></i> Tambah Transaksi
    </button>
  </div>
</div>

<div class="box-body table-responsive">
<table class="table table-bordered table-striped">
<thead>
<tr>
  <th>No</th>
  <th>Tanggal</th>
  <th>Kategori</th>
  <th>Keterangan</th>
  <th>Pemasukan</th>
  <th>Pengeluaran</th>
  <th>Opsi</th>
</tr>
</thead>
<tbody>

<?php
$no=1;
$data = mysqli_query($koneksi,"
  SELECT t.*, k.kategori
  FROM transaksi t
  JOIN kategori k ON k.kategori_id=t.transaksi_kategori
  ORDER BY t.transaksi_id DESC
");
while($d=mysqli_fetch_assoc($data)){
?>
<tr>
  <td><?= $no++ ?></td>
  <td><?= date('d-m-Y',strtotime($d['transaksi_tanggal'])) ?></td>
  <td><?= $d['kategori'] ?></td>
  <td><?= $d['transaksi_keterangan'] ?></td>
  <td><?= $d['transaksi_jenis']=='Pemasukan' ? 'Rp '.number_format($d['transaksi_nominal']) : '-' ?></td>
  <td><?= $d['transaksi_jenis']=='Pengeluaran' ? 'Rp '.number_format($d['transaksi_nominal']) : '-' ?></td>
  <td>
    <!-- EDIT -->
    <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#edit<?= $d['transaksi_id'] ?>">
      <i class="fa fa-cog"></i>
    </button>

    <!-- VIEW -->
    <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#lihat<?= $d['transaksi_id'] ?>">
      <i class="fa fa-eye"></i>
    </button>
  </td>
</tr>

<!-- MODAL EDIT -->
<div class="modal fade" id="edit<?= $d['transaksi_id'] ?>">
<div class="modal-dialog">
<div class="modal-content">
<form action="transaksi_update.php" method="post" enctype="multipart/form-data">
<div class="modal-header"><h4>Edit Transaksi</h4></div>
<div class="modal-body">
<input type="hidden" name="id" value="<?= $d['transaksi_id'] ?>">

<label>Tanggal</label>
<input type="date" name="tanggal" value="<?= $d['transaksi_tanggal'] ?>" class="form-control" required><br>

<label>Jenis</label>
<select name="jenis" class="form-control">
  <option <?= $d['transaksi_jenis']=='Pemasukan'?'selected':'' ?>>Pemasukan</option>
  <option <?= $d['transaksi_jenis']=='Pengeluaran'?'selected':'' ?>>Pengeluaran</option>
</select><br>

<label>Kategori</label>
<select name="kategori" class="form-control">
<?php
$kat=mysqli_query($koneksi,"SELECT * FROM kategori");
while($k=mysqli_fetch_assoc($kat)){
?>
<option value="<?= $k['kategori_id'] ?>" <?= $d['transaksi_kategori']==$k['kategori_id']?'selected':'' ?>>
  <?= $k['kategori'] ?>
</option>
<?php } ?>
</select><br>

<label>Nominal</label>
<input type="number" name="nominal" value="<?= $d['transaksi_nominal'] ?>" class="form-control"><br>

<label>Keterangan</label>
<textarea name="keterangan" class="form-control"><?= $d['transaksi_keterangan'] ?></textarea><br>

<label>Bank</label>
<select name="bank" class="form-control">
<?php
$bank=mysqli_query($koneksi,"SELECT * FROM bank");
while($b=mysqli_fetch_assoc($bank)){
?>
<option value="<?= $b['bank_id'] ?>" <?= $d['transaksi_bank']==$b['bank_id']?'selected':'' ?>>
  <?= $b['bank_nama'] ?>
</option>
<?php } ?>
</select><br>

<label>Upload File (opsional)</label>
<input type="file" name="trnfoto" class="form-control">
</div>

<div class="modal-footer">
  <button class="btn btn-primary">Simpan</button>
  <button class="btn btn-default" data-dismiss="modal">Batal</button>
</div>
</form>
</div>
</div>
</div>

<!-- MODAL VIEW -->
<div class="modal fade" id="lihat<?= $d['transaksi_id'] ?>">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header"><h4>Bukti</h4></div>
<div class="modal-body">
<embed src="../gambar/bukti/<?= $d['transaksi_foto'] ?>" width="100%" height="400">
</div>
</div>
</div>
</div>

<?php } ?>
</tbody>
</table>
</div>

</div>
</section>
</div>

<?php include 'footer.php'; ?>
