<?php
include '../koneksi.php';
include 'header.php';
?>

<div class="content-wrapper">
<section class="content-header">
  <h1>Transaksi <small>Data Transaksi</small></h1>
</section>

<section class="content">
<div class="box box-info">

<div class="box-header with-border">
  <h3 class="box-title">Transaksi Pemasukan & Pengeluaran</h3>
  <div class="pull-right">
    <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#modalTambah">
      <i class="fa fa-plus"></i> Tambah Transaksi
    </button>
  </div>
</div>

<div class="box-body table-responsive">
<table class="table table-bordered table-striped" id="table-datatable">
<thead>
<tr>
  <th>No</th>
  <th>Tanggal</th>
  <th>Kategori</th>
  <th>Project</th>
  <th>Keterangan</th>
  <th>Pemasukan</th>
  <th>Pengeluaran</th>
  <th>Opsi</th>
</tr>
</thead>
<tbody>

<?php
$no=1;
$data=mysqli_query($koneksi,"
  SELECT 
    t.*,
    k.kategori,
    p.nama_project
  FROM transaksi t
  LEFT JOIN kategori k ON k.kategori_id=t.transaksi_kategori
  LEFT JOIN project p ON p.id=t.transaksi_project
  ORDER BY t.transaksi_id DESC
");

while($d=mysqli_fetch_array($data)){
?>

<tr>
<td><?= $no++ ?></td>
<td><?= date('d-m-Y',strtotime($d['transaksi_tanggal'])) ?></td>
<td><?= $d['kategori'] ?></td>
<td><?= $d['nama_project'] ?? '-' ?></td>
<td><?= $d['transaksi_keterangan'] ?></td>

<td class="text-center">
<?= $d['transaksi_jenis']=="Pemasukan" ? "Rp. ".number_format($d['transaksi_nominal']).",-" : "-" ?>
</td>

<td class="text-center">
<?= $d['transaksi_jenis']=="Pengeluaran" ? "Rp. ".number_format($d['transaksi_nominal']).",-" : "-" ?>
</td>

<td>
<!-- ❌ EDIT DIHILANGKAN -->
<button class="btn btn-primary btn-xs" data-toggle="modal"
 data-target="#lihat<?= $d['transaksi_id'] ?>">
 <i class="fa fa-eye"></i>
</button>
</td>
</tr>

<!-- MODAL LIHAT -->
<div class="modal fade" id="lihat<?= $d['transaksi_id'] ?>">
<div class="modal-dialog modal-lg">
<div class="modal-content">
<div class="modal-header">
<h4 class="modal-title">Bukti Transaksi</h4>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body">
<?php if($d['transaksi_foto']!=""){ ?>
<embed src="../gambar/bukti/<?= $d['transaksi_foto'] ?>"
 type="application/pdf" width="100%" height="400">
<?php }else{ ?>
<p class="text-center text-muted">Tidak ada file</p>
<?php } ?>
</div>
</div>
</div>
</div>

<?php } ?>
</tbody>
</table>
</div>
</div>
</section>
</div>

<!-- ================= MODAL TAMBAH (SAMA PERSIS ADMIN) ================= -->
<form action="transaksi_act.php" method="post" enctype="multipart/form-data">
<div class="modal fade" id="modalTambah">
<div class="modal-dialog">
<div class="modal-content">

<div class="modal-header">
<h4 class="modal-title">Tambah Transaksi</h4>
<button type="button" class="close" data-dismiss="modal">&times;</button>
</div>

<div class="modal-body">

<div class="form-group">
<label>Tanggal</label>
<input type="date" name="tanggal" class="form-control" required>
</div>

<div class="form-group">
<label>Jenis</label>
<select name="jenis" class="form-control" required>
<option value="">- Pilih -</option>
<option value="Pemasukan">Pemasukan</option>
<option value="Pengeluaran">Pengeluaran</option>
</select>
</div>

<div class="form-group">
<label>Kategori</label>
<select name="kategori" class="form-control" required>
<option value="">- Pilih -</option>
<?php
$kategori=mysqli_query($koneksi,"SELECT * FROM kategori ORDER BY kategori ASC");
while($k=mysqli_fetch_array($kategori)){
?>
<option value="<?= $k['kategori_id'] ?>"><?= $k['kategori'] ?></option>
<?php } ?>
</select>
</div>

<div class="form-group">
<label>Project</label>
<select name="project" class="form-control">
<option value="">- Tanpa Project -</option>
<?php
$project=mysqli_query($koneksi,"SELECT * FROM project ORDER BY nama_project ASC");
while($p=mysqli_fetch_array($project)){
?>
<option value="<?= $p['id'] ?>"><?= $p['nama_project'] ?></option>
<?php } ?>
</select>
</div>

<div class="form-group">
<label>Nominal</label>
<input type="number" name="nominal" class="form-control" required>
</div>

<div class="form-group">
<label>Keterangan</label>
<textarea name="keterangan" class="form-control"></textarea>
</div>

<div class="form-group">
<label>Upload Bukti</label>
<input type="file" name="trnfoto" class="form-control">
</div>

<div class="form-group">
<label>Rekening Bank</label>
<select name="bank" class="form-control" required>
<option value="">- Pilih -</option>
<?php
$bank=mysqli_query($koneksi,"SELECT * FROM bank");
while($b=mysqli_fetch_array($bank)){
?>
<option value="<?= $b['bank_id'] ?>"><?= $b['bank_nama'] ?></option>
<?php } ?>
</select>
</div>

</div>

<div class="modal-footer">
<button type="button" class="btn btn-default" data-dismiss="modal">Tutup</button>
<button type="submit" class="btn btn-primary">Simpan</button>
</div>

</div>
</div>
</div>
</form>

<?php include 'footer.php'; ?>
